--***********************************************************
--**                    ShadowCop		                   **
--***********************************************************

require "TimedActions/ISBaseTimedAction"

ISChopTreeChainsawAction = ISBaseTimedAction:derive("ISChopTreeChainsawAction")

function ISChopTreeChainsawAction:isValid()
	return (self.tree ~= nil and self.tree:getObjectIndex() >= 0 and self.character:CanAttack() and self.character:getPrimaryHandItem() ~= nil and self.character:getPrimaryHandItem():getType() == "Chainsaw" and self.character:getPrimaryHandItem():getModData().Run == true)
end

function ISChopTreeChainsawAction:update()

    self.chainsaw:setJobDelta(self:getJobDelta());
	self.character:PlayAnim("Attack_" .. self.chainsaw:getSwingAnim())
	local val = self.chainsaw:getSwingTime()
	if self.chainsaw:isUseEndurance() then
		local moodleLevel = self.character:getMoodles():getMoodleLevel(MoodleType.Endurance)
		if moodleLevel == 1 then val = val * 1.1
		elseif moodleLevel == 2 then val = val * 1.2
		elseif moodleLevel == 3 then val = val * 1.3
		elseif moodleLevel == 4 then val = val * 1.4 end
	end
	if val < self.chainsaw:getMinimumSwingTime() then
		val = self.chainsaw:getMinimumSwingTime()
	end
	val = val * self.chainsaw:getSpeedMod(self.character)
	local AttackDelayMax = val * 0.6
	local numFrames = self.character:getSpriteDef():getFrameCount()
	local perFrame = numFrames / 60 / AttackDelayMax
	self.character:getSpriteDef():setFrameSpeedPerFrame(perFrame * 2)
	
	self.character:setIgnoreMovementForDirection(false)
	self.character:faceThisObject(self.tree)
	self.character:setIgnoreMovementForDirection(true)

	local AttackDelayUse = 0.3 * numFrames
	if self.spriteFrame < AttackDelayUse and self.character:getSpriteDef():getFrame() >= AttackDelayUse then
		self.tree:WeaponHit(self.character, self.chainsaw)
		
		-- Chainsaw Sound & Fuel
		chainsaw_fuel(self.character, self.chainsaw, 1, 0)
		
		if self.tree:getObjectIndex() < 0 then
			self.character:PlayAnimUnlooped("Attack_" .. self.chainsaw:getSwingAnim())
		end
		self:useEndurance()
		if ZombRand(self.chainsaw:getConditionLowerChance() * 2 + self.character:getMaintenanceMod() * 2) == 0 then
			self.chainsaw:setCondition(self.chainsaw:getCondition() - 1)
            ISWorldObjectContextMenu.checkWeapon(self.character);
		else
			self.character:getXp():AddXP(Perks.BladeMaintenance, 1)
		end
	end
	self.spriteFrame = self.character:getSpriteDef():getFrame()
end

function ISChopTreeChainsawAction:start()
    self.chainsaw = self.character:getPrimaryHandItem()
    self.action:setTime(math.max((self.tree:getHealth() / self.chainsaw:getTreeDamage()) * 100 + 10, 50))
    self.chainsaw:setJobType(getText("ContextMenu_Chop_Tree"));
    self.chainsaw:setJobDelta(0.0);
    self.character:PlayAnim("Attack_" .. self.chainsaw:getSwingAnim())
    self.spriteFrame = self.character:getSpriteDef():getFrame()
	if self.character:getAccessLevel() ~= "None" then
		self.tree:setHealth(1)
	end
end

function ISChopTreeChainsawAction:stop()
	if self.character:getPrimaryHandItem() and self.character:getPrimaryHandItem() == self.chainsaw then
		self.character:PlayAnimUnlooped("Attack_" .. self.chainsaw:getSwingAnim())
	else
		self.character:PlayAnim("Idle")
	end
	self.character:setIgnoreMovementForDirection(false)
    ISBaseTimedAction.stop(self)
    self.chainsaw:setJobDelta(0.0);
end

function ISChopTreeChainsawAction:perform()
    self.chainsaw:setJobDelta(0.0);

	if self.character:getPrimaryHandItem() and self.character:getPrimaryHandItem() == self.chainsaw then
		self.character:PlayAnimUnlooped("Attack_" .. self.chainsaw:getSwingAnim())
	else
		self.character:PlayAnim("Idle")
	end
	self.character:setIgnoreMovementForDirection(false)
	
	-- needed to remove from queue / start next.
    ISBaseTimedAction.perform(self)
end

function ISChopTreeChainsawAction:useEndurance()
	if self.chainsaw:isUseEndurance() then
		local use = self.chainsaw:getWeight() * self.chainsaw:getFatigueMod(self.character) * self.character:getFatigueMod() * self.chainsaw:getEnduranceMod() * 0.1
		local useChargeDelta = 1.0
		use = use * useChargeDelta * 0.041
		if self.chainsaw:isTwoHandWeapon() and self.character:getSecondaryHandItem() ~= self.chainsaw then
			use = use + self.chainsaw:getWeight() / 1.5 / 10 / 20
		end
		self.character:getStats():setEndurance(self.character:getStats():getEndurance() - use)
	end
end

function ISChopTreeChainsawAction:new(character, tree)
	local o = {}
	setmetatable(o, self)
	self.__index = self
	o.character = character
	o.tree = tree
	o.stopOnWalk = true
	o.stopOnRun = true
	o.maxTime = 300
	o.spriteFrame = 0
    o.caloriesModifier = 8;
	return o
end